@echo off

set basic=
set upt=
set comNumber=
set deviceFound=0
set fwDeviceVersion=

set tool=VcpSdkCmd.exe
set portAddress=ua
set vcpAddressLocal=000000000000 0000 FFFF
set vcpAddressRemote=000000000000 0000 0010
set flags=
set bank1=1
set bank2=2

set delimiter=======================================

echo %delimiter%
echo U-BRIDGE 3 Updater
echo %delimiter%

rem Check if the basic variable is set
if "%basic%"=="" (
    for %%f in (*.Hex) do (
        set basic=%%f
        goto :continue
    )
    echo No firmware file in current folder. Exiting...
    pause
    exit /b 1
)

:continue

echo Checking port...
for /f "tokens=*" %%i in ('%tool% %flags% %portAddress% VCPGET %vcpAddressLocal% 00010300 8 ^| findstr /i "VS6320"') do (
    set comNumber=%%i
)
REM Extract the port number without the "COM" prefix and any trailing characters
for /f "tokens=1 delims= " %%j in ("%comNumber%") do (
    set portNumber=%%j
    set deviceFound=1 
)

REM Check if device was found
if %deviceFound%==0 (
    echo Device not found. Exiting...
    pause
    exit /b 1
)

echo Checking installed version...
for /f "tokens=4 delims=- " %%k in ("%comNumber%") do (
    set fwDeviceVersion=%%k
)

REM Extract the version substring from the basic filename
for /f "tokens=4 delims=_Hh" %%i in ("%basic%") do (
    set fwFileVersion=%%i
)
set fwFileVersion=%fwFileVersion:~0,-1%

echo Installed version: %fwDeviceVersion%
echo Required version: %fwFileVersion%
if "%fwDeviceVersion%"=="%fwFileVersion%" (
    echo Device already up-to-date. Exiting...
    pause
    exit /b 1
) else (
    echo Device needs to be updated...
)

set portAddress=%portNumber%

echo %delimiter%
echo Programming local device...
%tool% %flags% %portAddress% ERASE %vcpAddressLocal% %bank1%
%tool% %flags% %portAddress% BURN %vcpAddressLocal% %bank1% %basic%
if "%upt%" NEQ "" (
    echo Programming UPT...
    %tool% %flags% %portAddress% ERASE %vcpAddressLocal% %bank2%
    %tool% %flags% %portAddress% BURN %vcpAddressLocal% %bank2% %upt%
)

echo %delimiter%
echo Programming remote device...
%tool% %flags% %portAddress% ERASE %vcpAddressRemote% %bank1%
%tool% %flags% %portAddress% BURN %vcpAddressRemote% %bank1% %basic%
if "%upt%" NEQ "" (
    echo Programming UPT...
    %tool% %flags% %portAddress% ERASE %vcpAddressLocal% %bank2%
    %tool% %flags% %portAddress% BURN %vcpAddressLocal% %bank2% %upt%
)

echo Resetting device...
%tool% %flags% %portAddress% VCPSET %vcpAddressLocal% 00010604 01

echo %delimiter%
echo Programming successful!

pause